#include "wrapper.h"
#include <stdio.h>
// #include <stdbool.h>

int main()
{
    double wavelengths[WLS_NUM];
	int    intensities[WLS_NUM];
	int    refIntensity[WLS_NUM];

	int deviceIndex = 0;

	//通过USB接口初始化并打开设备
	int ret = dlpInitUsb();

	ret = dlpOpenByUsb(deviceIndex);
	if (ret == RetSuccess)
	{
		printf("Open Device Success.\n\n");
	}

	//获取波长范围和序列号
	PynScanConfig config;
	ret = dlpGetConfigInfo(&config);
	if (ret == RetSuccess)
	{
		//打印波长范围
		printf("Device serial number: %s\n", config.head.scanConfig_serial_number);
		printf("Wavelength range: %d - %d nm\n\n", config.section[0].wavelength_start_nm, config.section[0].wavelength_end_nm);
	}


	char cmd;
	int exitFlag = 0;
	while (!exitFlag)
	{
		printf("input 'q' exit: ");
		scanf(" %c", &cmd);
		printf("\n");

		switch (cmd)
		{		
		case '1':								//get scanResults
			PynScanResults results;
			ret = dlpGetScanResults(&results);
			if (ret<0)
			{
				printf("dlpGetScanResults failure! %d\n",ret);
			}
			else
			{
				printf("dlpGetScanResults ok!\n");
				printf("system temprature: %.2f%%\n",results.system_temp_hundredths/100.0);
				printf("humidity: %.2f%%\n",results.humidity_hundredths/100.0);
				for (size_t i = 0; i < 5; i++)
				{
					printf("%.3f:  %d\n",results.wavelength[i],results.intensity[i]);
				}
				printf("\n");
			}
			break;			
		case '2':								//get wavelengths
			ret = dlpGetWavelengths(wavelengths,WLS_NUM);
			printf("dlpGetWavelengths ret: %d!\n\n",ret);
			if (ret<0)
			{
				printf("dlpGetWavelengths failure!\n");
			}
			else
			{
				printf("dlpGetWavelengths ok!\n");
				for (int i = 0; i < 5; i++)
				{
					printf("wl[%d]: %.3f nm\n", i, wavelengths[i]);
				}
				
				printf("\n");
			}
			break;
		case '3':								//get intensities
			int activeIndex = 0;
			ret = dlpGetIntensities(activeIndex,intensities,WLS_NUM);
			if (ret<0)
			{
				printf("dlpGetIntensities failure! %d\n",ret);
			}
			else
			{
				printf("dlpGetIntensities ok!\n");
				for (size_t i = 100; i < 105; i++)
				{
					printf("%.3f:  %d\n",wavelengths[i],intensities[i]);
				}
				printf("\n");
			}
			break;
		case '4':								//get ref intensity in device
			ret = dlpGetRefIntensityFromDevice(refIntensity, WLS_NUM);
			if (ret<0)
			{
				printf("dlpGetRefIntensFromDevice failure! %d\n",ret);
			}
			else
			{
				printf("dlpGetRefIntensFromDevice ok!\n");
				for (size_t i = 0; i < 5; i++)
				{
					printf("%.3f:  %d\n",wavelengths[i], refIntensity[i]);
				}
				printf("\n");
			}
			break;			
		case '5':								//set lamp on (yes)
			printf("Set lamp on or off(1: on; 0: off): ");	
			int enable;	
			scanf("%d",&enable);		
			if (1 == enable) {
				ret = dlpSetLampStatus(true);
				printf("dlpSetLampStatus: on\n");
			}	
			else if (0 == enable) {
				ret = dlpSetLampStatus(false);
				printf("dlpSetLampStatus: off\n");
			}	
			else {
				printf("input value is invalid\n");
			}

			if (ret<0)	{
				printf("dlpSetLampStatus failure!\n");
			}

			printf("\n\n");
			break;				
		case '6':				
			printf("Enable button press or not(1: enable; 0: disable): ");	
			scanf("%d",&enable);		
			if (1 == enable) {
				ret = dlpEnableButtonPress(true);
			}	
			else if (0 == enable) {
				ret = dlpEnableButtonPress(false);
			}	
			else {
				printf("input value is invalid\n");
			}

			if (ret<0)	{
				printf("dlpEnableButtonPress failure!\n");
			}
			printf("\n\n");
			break;	
		case '7':	
			bool isBtnPressed = false;						
			ret = dlpGetButtonPressStatus(&isBtnPressed);
			if (ret<0)
			{
				printf("dlpGetButtonPressStatus failure!\n");
			}
			else
			{
				printf("dlpGetButtonPressStatus: %d\n", isBtnPressed);
			}
			printf("\n\n");
			break;	
		case '8':
			printf("Enable bluetooth press or not(1: enable; 0: disable): ");	
			scanf("%d",&enable);		
			if (1 == enable) {
				ret = dlpSetBluetoothStatus(true);
			}	
			else if (0 == enable) {
				ret = dlpSetBluetoothStatus(false);
			}	
			else {
				printf("input value is invalid\n");
			}

			if (ret<0)	{
				printf("dlpEnableButtonPress failure!\n");
			}
			printf("\n\n");			
			break;							
		case '9':								
			uint8 uuid[8] = {0};	//UUID是8个字节
			ret = dlpGetDeviceUuid(uuid);
			if (ret<0)
			{
				printf("dlpGetDeviceUuid failure!\n");
			}
			else
			{
				printf("Device UUID is: ");
				for (size_t i = 0; i < sizeof(uuid); i++)
				{
					printf("%02X:",uuid[i]);
				}	
			}
			printf("\n\n");
			break;		
		case 'a':
			uint32 humidity, temperature;
			ret = dlpGetHumTemp(&humidity, &temperature);
			if (ret<0)
			{
				printf("dlpGetHumTemp failure!\n");
			}
			else
			{
				printf("Humidity: %.2f, Temperature: %.2f", humidity/100.0, temperature/100.0);
				printf("\n\n");
			}
			break;	
		case 'b':
			uint32 batteryVolt, batteryPercent;
			ret = dlpGetBatteryInfo(&batteryVolt, &batteryPercent);
			if (ret<0)
			{
				printf("dlpGetBatteryInfo failure\n");
			}
			else
			{
				printf("BatteryVolt: %.2f, BatteryPercent: %.2f\n", humidity/100.0, temperature/100.0);
				printf("\n\n");
			}
			break;		
		case 'c':
			int gain;	
			printf("Input the gain value(1,2,4,8,16,32 or 64): ");	
			scanf("%d",&gain);								
			ret = dlpSetPgaGain(gain);
			if (ret<0)	printf("dlpSetPgaGain failure!\n");
			else	printf("dlpSetPgaGain ok! Current PGA gain is %d\n", gain);
			printf("\n\n");
			break;	
		case 'd':
			int pgaGain;
			ret = dlpGetPgaGain(&pgaGain);
			if (ret<0)
			{
				printf("dlpGetPgaGain failure!\n");
			}
			else
			{
				printf("The current PGA gain is %d\n", pgaGain);
				printf("\n\n");
			}
			break;	
		case 'e':
			int avg;	
			printf("Input the average scan times: ");	
			scanf("%d",&avg);								
			ret = dlpSetAvgTimes(avg);
			if (ret<0)	printf("dlpSetAvgTimes failure!\n");
			else	printf("dlpSetAvgTimes ok! Current average scan times is setted to %d\n", avg);
			printf("\n\n");
			break;	
		case 'q':
			exitFlag = 1;  // 设置退出标志，终止循环
			dlpClose(deviceIndex);
			break;									
		default:
			break;			
		}
		/* code */
	}

    return 0;
}