#include "wrapper.h"
#include <stdio.h>
// #include <stdbool.h>

int main()
{
    double wavelengths[WLS_NUM];
	int    intensities[WLS_NUM];
	int    refIntensity[WLS_NUM];

	int deviceIndex = 0;

	int ret = dlpInitUsb();

	ret = dlpOpenByUsb(deviceIndex);
	if (ret == RetSuccess)
	{
		printf("Open Device Success.\n");
	}

	PynScanConfig config;

	char cmd;
	int exitFlag = 0;
	while (!exitFlag)
	{
		printf("input 'q' exit: ");
		scanf(" %c", &cmd);
		printf("\n");

		switch (cmd)
		{		
		case '1':								//获取前5个波长和对应的强度值
			PynScanResults results;
			ret = dlpGetScanResults(&results);
			if (ret<0)
			{
				printf("dlpGetScanResults failure! %d\n",ret);
			}
			else
			{
				printf("dlpGetScanResults ok!\n");
				printf("system temprature: %.2f%%\n",results.system_temp_hundredths/100.0);
				printf("humidity: %.2f%%\n",results.humidity_hundredths/100.0);
				for (size_t i = 0; i < 5; i++)
				{
					printf("%.3f:  %d\n",results.wavelength[i],results.intensity[i]);
				}
				printf("\n");
			}
			break;			
		case '2':								//获取前5个波长值
			ret = dlpGetWavelengths(wavelengths,WLS_NUM);
			printf("dlpGetWavelengths ret: %d!\n\n",ret);
			if (ret<0)
			{
				printf("dlpGetWavelengths failure!\n");
			}
			else
			{
				printf("dlpGetWavelengths ok!\n");
				for (int i = 0; i < 5; i++)
				{
					printf("wl[%d]: %.3f nm\n", i, wavelengths[i]);
				}
				
				printf("\n");
			}
			break;
		case '3':								//获取第100-105个波长和对应的强度值
			int activeIndex = 0;
			ret = dlpGetIntensities(activeIndex,intensities,WLS_NUM);
			if (ret<0)
			{
				printf("dlpGetIntensities failure! %d\n",ret);
			}
			else
			{
				printf("dlpGetIntensities ok!\n");
				for (size_t i = 100; i < 105; i++)
				{
					printf("%.3f:  %d\n",wavelengths[i],intensities[i]);
				}
				printf("\n");
			}
			break;
		case '4':								//获取设备内部的参比值
			ret = dlpGetRefIntensityFromDevice(refIntensity, WLS_NUM);
			if (ret<0)
			{
				printf("dlpGetRefIntensFromDevice failure! %d\n",ret);
			}
			else
			{
				printf("dlpGetRefIntensFromDevice ok!\n");
				for (size_t i = 0; i < 5; i++)
				{
					printf("%.3f:  %d\n",wavelengths[i], refIntensity[i]);
				}
				printf("\n");
			}
		case '5':								//设置灯光开关
			printf("Set lamp on or off(1: on; 0: off): ");	
			int enable;	
			scanf("%d",&enable);		
			if (1 == enable) {
				ret = dlpSetLampStatus(true);
				printf("dlpSetLampStatus: on\n");
			}	
			else if (0 == enable) {
				ret = dlpSetLampStatus(false);
				printf("dlpSetLampStatus: off\n");
			}	
			else {
				printf("input value is invalid\n");
			}

			if (ret<0)	{
				printf("dlpSetLampStatus failure!\n");
			}

			printf("\n\n");
			break;				
		case '6':		//启用或禁用按键			
			printf("Enable button press or not(1: enable; 0: disable): ");	
			scanf("%d",&enable);		
			if (1 == enable) {
				ret = dlpEnableButtonPress(true);
			}	
			else if (0 == enable) {
				ret = dlpEnableButtonPress(false);
			}	
			else {
				printf("input value is invalid\n");
			}

			if (ret<0)	{
				printf("dlpEnableButtonPress failure!\n");
			}
			printf("\n\n");
			break;	
		case '7':	//获取按键状态		
			bool isBtnPressed = false;						
			ret = dlpGetButtonPressStatus(&isBtnPressed);
			if (ret<0)
			{
				printf("dlpGetButtonPressStatus failure!\n");
			}
			else
			{
				printf("dlpGetButtonPressStatus: %d\n", isBtnPressed);
			}
			printf("\n\n");
			break;	
		case '8':	//启用或禁用蓝牙状态
			printf("Enable bluetooth press or not(1: enable; 0: disable): ");	
			scanf("%d",&enable);		
			if (1 == enable) {
				ret = dlpSetBluetoothStatus(true);
			}	
			else if (0 == enable) {
				ret = dlpSetBluetoothStatus(false);
			}	
			else {
				printf("input value is invalid\n");
			}

			if (ret<0)	{
				printf("dlpEnableButtonPress failure!\n");
			}
			printf("\n\n");			
			break;							
		case '9':		//获取UUID						
			uint8 uuid[8] = {0};	//UUID是8个字节
			ret = dlpGetDeviceUuid(uuid);
			if (ret<0)
			{
				printf("dlpGetDeviceUuid failure!\n");
			}
			else
			{
				printf("Device UUID is: ");
				for (size_t i = 0; i < sizeof(uuid); i++)
				{
					printf("%02X:",uuid[i]);
				}	
			}
			printf("\n\n");
			break;		
		case 'a':		//获取湿度和温度
			uint32 humidity, temperature;
			ret = dlpGetHumTemp(&humidity, &temperature);
			if (ret<0)
			{
				printf("dlpGetHumTemp failure!\n");
			}
			else
			{
				printf("Humidity: %.2f, Temperature: %.2f", humidity/100.0, temperature/100.0);
				printf("\n\n");
			}
		case 'b':		//获取电池信息
			uint32 batteryVolt, batteryPercent;
			ret = dlpGetBatteryInfo(&batteryVolt, &batteryPercent);
			if (ret<0)
			{
				printf("dlpGetBatteryInfo failure\n");
			}
			else
			{
				printf("BatteryVolt: %.2f, BatteryPercent: %.2f\n", humidity/100.0, temperature/100.0);
				printf("\n\n");
			}
			break;		
		case 'c':		//设置增益
			int gain;	
			printf("Input the gain value(1,2,4,8,16,32 or 64): ");	
			scanf("%d",&gain);								
			ret = dlpSetPgaGain(gain);
			if (ret<0)	printf("dlpSetPgaGain failure!\n");
			else	printf("dlpSetPgaGain ok! Current PGA gain is %d\n", gain);
			printf("\n\n");
			break;	
		case 'd':		//获取增益
			int pgaGain;
			ret = dlpGetPgaGain(&pgaGain);
			if (ret<0)
			{
				printf("dlpGetPgaGain failure!\n");
			}
			else
			{
				printf("The current PGA gain is %d\n", pgaGain);
				printf("\n\n");
			}
			break;	
		case 'q':		//退出程序
			exitFlag = 1;  // 设置退出标志，终止循环
			dlpClose(deviceIndex);
			break;									
		default:
			break;			
		}
		/* code */
	}

    return 0;
}